package com.bytesbee.mysinglelivechannel.activities;

import static com.bytesbee.mysinglelivechannel.utils.Constant.ZERO;

import android.os.Bundle;
import android.os.Handler;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.bytesbee.mysinglelivechannel.BuildConfig;
import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.managers.Screens;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.Constant;
import com.bytesbee.mysinglelivechannel.utils.Utils;

public class SplashActivity extends BaseAppActivity {
    private int NEW_SPLASH_TIME = Constant.SPLASH_TIME;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);

        setImmersionBar();

        ((TextView) findViewById(R.id.txtVersionName)).setText(String.format(getString(R.string.app_version), BuildConfig.VERSION_NAME));
        ((TextView) findViewById(R.id.txtName)).setText(String.format(getString(R.string.app_company_name), getString(R.string.app_company)));

        if (Utils.isOnline(this)) {
            Utils.requestSettingApi(getApplicationContext(), dataHandler);
        } else {
            NEW_SPLASH_TIME = Constant.SPLASH_TIME;
            showNextScreen();
        }
    }

    private final Handler dataHandler = new Handler(message -> {
        NEW_SPLASH_TIME = Constant.DEFAULT_DELAY;
        showNextScreen();
        return true;
    });

    private void showNextScreen() {
        android.os.Handler handler = new android.os.Handler(msg -> {
            Class<?> myClass = MainActivity.class;
            if (Utils.isEnabledMandatoryLogin()) {
                if (SessionManager.get().isNotLoggedIn()) {
                    myClass = LoginActivity.class;
                }
            }
            Screens.showClearTopScreen(mActivity, myClass);
            return true;
        });
        handler.sendEmptyMessageDelayed(ZERO, NEW_SPLASH_TIME);

    }

}
